import os

from xml.etree import ElementTree

from lt2http.addon import ADDON, ADDON_PATH
from lt2http.util import translatePath

LT2HTTP_HOST = "http://127.0.0.1:65225"

get_setting = ADDON.getSetting

def init():
    global LT2HTTP_HOST

    try:
        LT2HTTP_HOST = "http://" + ADDON.getSetting("remote_host") + ":" + ADDON.getSetting("remote_port")
    except:
        pass

def get_all_settings_spec():
    data = ElementTree.parse(os.path.join(ADDON_PATH, "resources", "settings.xml"))
    for element in data.findall("*/setting"):
        yield dict(element.attrib)

def get_setting_by_spec(spec):
    t = spec["type"]
    if t in ("number", "enum"):
        handle = get_int_setting
    elif t == "slider":
        # May be 'int', 'float' or 'percent'
        if spec.get("option") == "int":
            handle = get_int_setting
        else:
            handle = get_float_setting
    elif t == "bool":
        handle = get_boolean_setting
    else:
        handle = get_setting
    return handle(spec["id"])

def get_boolean_setting(setting):
    return get_setting(setting) == "true"


def get_int_setting(setting):
    try:
        return int(get_setting(setting))
    except:
        return 0


def get_float_setting(setting):
    try:
        return float(get_setting(setting))
    except:
        return 0

def get_current_settings():
    specs = get_all_settings_spec()
    res = {}

    for spec in specs:
        if 'id' not in spec:
            continue

        res[spec["id"]] = get_setting_by_spec(spec)
        if spec["id"].endswith("_path"):
            res[spec["id"]] = translatePath(res[spec["id"]])
        elif spec["id"].endswith("_interfaces"):
            res[spec["id"]] = [res[spec["id"]]]
        elif spec["id"] == 'download_storage':
            res[spec["id"]] = res[spec["id"]] + 1

    return res


init()
